<?php
// Text
function length($value, $length)
{
	return strlen($value) == $length;
}

function min_length($value, $min)
{
	return strlen($value) >= $min;
}

function max_length($value, $max)
{
	return strlen($value) <= $max;
}

function email($value, $require)
{
	return !$require || preg_match('/^(.+)\@(.+)\.(.+)$/', $value);
}

function match($value, $field, $form)
{
	return $value == $form->request($field);
}

function alphanumeric($value, $require)
{
	return !$require || preg_match('/^\w+$/', $value);
}

function positive_integer($value, $require)
{
	return !$require || ($value != '0' && ctype_digit((string) $value));
}

function non_negative_integer($value, $require)
{
	return !$require || ctype_digit((string) $value);
}

function less_than($value, $max)
{
	return $value < $max;
}

// File
function max_filesize($field, $size)
{
	return (!isset($field->file['error']) || !$field->file['error']) && $field->file['size'] <= $size;
}

function file_type($field, $type)
{
	switch($type)
	{
		case 'swf':
			return $field->file['type'] == 'application/x-shockwave-flash';
		break;
		case 'image':
			return substr($field->file['type'], 0, 6) == 'image/';
		break;
	}
}

function image_size($file, $size)
{
	if($file->host)
	{
		return true;
	}
	
	$image = $file->image();
	
	return $image->width() == $size[0] && $image->height() == $size[1];
}

function url($file, $prepend)
{
	if($prepend && substr($file, 0, 4) != 'http')
	{
		$file = 'http://'.$file;
	}
	
	return @get_headers($file)?true:false;
}